#!/usr/bin/env python3
#
# props.py
# Kludged by Kevin Cole <ubuntourist@hacdc.org> 2024.04.30 (kjc)
#
# Get properties / settings / attributes of all scene items of Text
# pthread source type.
#
# Kludged together from a Lua script and a LOT of trial and error. See:
#
#   https://obsproject.com/forum/threads/obs-lua-scene-item-to-source.125312/#post-467334
#   https://github.com/exeldro/obs-lua/blob/master/refresh-browsers.lua
#
# After editing, restart OBS Studio and reload. (Tools -> Scripts ->
# highlight this script -> reload circular arrow button.)
#

from os.path import expanduser      # Cross-platform home directory finder
import obspython as obs
import json
from datetime import datetime


def script_description():
    """Create a description to be displayed in the Scripts dialog window"""
    desc  = """<p><strong>Props</strong></p>"""
    desc += """<p>Show the properties of a particular source.</p>"""
    return desc


def show_text_pthread_settings():
    """Create a log file with lots of info for every Text pthread scene item"""
    obslog = open(expanduser("~/Learn/Music/Studio/scripting/props.log"), "w")
    print(f"Log started:  {datetime.now().isoformat()}")
    obslog.write(f"Log started:  {datetime.now().isoformat()}\n\n")
    sources = obs.obs_enum_sources()
    if sources != None:
        for source in sources:
            source_id = obs.obs_source_get_unversioned_id(source)
            if True:
#           if source_id == "obs_text_pthread_source":
                obslog.write(f"{'='*78}\n")
                obslog.write(f"name           = {obs.obs_source_get_name(source)}\n")
                obslog.write(f"  ID           = {obs.obs_source_get_id(source)}\n")
                obslog.write(f"  UUID         = {obs.obs_source_get_uuid(source)}\n")
                obslog.write(f"  type         = {obs.obs_source_get_type(source)}\n")
                obslog.write(f"  width        = {obs.obs_source_get_width(source)}\n")
                obslog.write(f"  height       = {obs.obs_source_get_height(source)}\n")
                obslog.write(f"  display_name = {obs.obs_source_get_display_name(source_id)}\n")

# ============================================================================
                obslog.write(f"  {'-'*76}\n  PROPERTIES:\n")
                obslog.write(f"  properties   = {obs.obs_source_properties(source)}\n")
                wtf = obs.obs_source_properties(source)         # DEBUG
#               help(wtf)                                       # DEBUG
#               print(type(wtf))                                # DEBUG
#               print(dir(wtf))                                 # DEBUG
#               for thing in dir(wtf):                          # DEBUG
#                   print(thing)                                # DEBUG
# ============================================================================
#               things = dir(wtf)                               # DEBUG
#               for thing in things:                            # DEBUG
#                   try:                                        # DEBUG
#                       thing_value = getattr(wtf, thing)       # DEBUG
#                       print(f"wtf.{thing} = {thing_value}")   # DEBUG
#                   except AttributeError:                      # DEBUG
#                       print(f"wtf.{thing} = ?")               # DEBUG
# ============================================================================
#               things = vars(wtf)                              # DEBUG
#               print("Custom attributes:")                     # DEBUG
#               for attr, value in things.items():              # DEBUG
#                   print(f"  - {attr}: {value}")               # DEBUG
# ============================================================================
#               all_wtf = {}                                    # DEBUG
#               for prop_name in obs.get_property_list(wtf):    # DEBUG
#                   all_wtf[prop_name] = obs.obs_properties_get(wtf, prop_name)
#               print(all_props)                                # DEBUG
# ============================================================================
#               obslog.write(f"  properties2  = {obs.obs_source_get_properties2(source)}\n")

                obslog.write(f"  {'-'*76}\n  PRIVATE SETTINGS:\n")
                privates = obs.obs_source_get_private_settings(source)
                defaults = obs.obs_data_get_defaults(privates)
                jason = obs.obs_data_get_json(defaults)
                obslog.write(f"  defaults     = {jason}\n")
                dick = json.loads(jason)
                for kee in dick:
                    obslog.write(f"    {kee} = {dick[kee]}\n")
                obslog.write(f"  {'_'*76}\n\n")
#               obslog.write(f"defaults2    = {obs.obs_data_get_defaults2(privates)}\n")
                jason = obs.obs_data_get_json(privates)
                obslog.write(f"  privates     = {jason}\n")
                dick = json.loads(jason)
                for kee in dick:
                    obslog.write(f"    {kee} = {dick[kee]}\n")

                obslog.write(f"  {'-'*76}\n  SETTINGS:\n")
                settings = obs.obs_source_get_settings(source)
                defaults = obs.obs_data_get_defaults(settings)
                jason = obs.obs_data_get_json(defaults)
                obslog.write(f"  defaults     = {jason}\n")
                dick = json.loads(jason)
                for kee in dick:
                    obslog.write(f"    {kee} = {dick[kee]}\n")
                obslog.write(f"  {'_'*76}\n\n")
#               obslog.write(f"defaults2    = {obs.obs_data_get_defaults2(settings)}\n")
                jason = obs.obs_data_get_json(settings)
                obslog.write(f"    {jason}\n")
                dick = json.loads(jason)
                for kee in dick:
                    obslog.write(f"    {kee} = {dick[kee]}\n")
                obs.obs_data_release(settings)

    obs.source_list_release(sources)
    print(f"Log finished: {datetime.now().isoformat()}")
    obslog.write(f"{'='*78}\n\nLog finished: {datetime.now().isoformat()}\n")
    obslog.close()

show_text_pthread_settings()
